/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class LevelType extends Internal.Enum<Internal.LevelType> {
        getDtoIndex(): number;
        getName(): net.minecraft.network.chat.Component;
        static valueOf($$0: string): Internal.LevelType;
        static values(): Internal.LevelType[];
        get dtoIndex(): number
        get name(): net.minecraft.network.chat.Component
        static readonly AMPLIFIED: Internal.LevelType;
        static readonly DEFAULT: Internal.LevelType;
        static readonly LARGE_BIOMES: Internal.LevelType;
        static readonly FLAT: Internal.LevelType;
    }
    type LevelType_ = "flat" | LevelType | "large_biomes" | "amplified" | "default";
    class InterfaceBlock extends Internal.AEBaseEntityBlock<Internal.InterfaceBlockEntity> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type InterfaceBlock_ = InterfaceBlock;
    class CarvingMaskPlacement extends Internal.PlacementModifier {
        static forStep($$0: Internal.GenerationStep$Carving_): Internal.CarvingMaskPlacement;
        static readonly CODEC: Internal.Codec<Internal.CarvingMaskPlacement>;
    }
    type CarvingMaskPlacement_ = CarvingMaskPlacement;
    interface AgeableListModelAccessor {
        abstract porting_lib$scaleHead(): boolean;
        abstract porting_lib$bodyYOffset(): number;
        abstract porting_lib$babyYHeadOffset(): number;
        abstract porting_lib$babyHeadScale(): number;
        abstract porting_lib$babyZHeadOffset(): number;
        abstract porting_lib$babyBodyScale(): number;
    }
    type AgeableListModelAccessor_ = AgeableListModelAccessor;
    class ColoredParticleInitialData {
        constructor(color: number)
        color: number;
    }
    type ColoredParticleInitialData_ = ColoredParticleInitialData;
    interface EncasedBlock {
        abstract getCasing(): Internal.Block;
        handleEncasing(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, heldItem: Internal.ItemStack_, player: Internal.Player_, hand: Internal.InteractionHand_, ray: Internal.BlockHitResult_): void;
        get casing(): Internal.Block
        (): Internal.Block_;
    }
    type EncasedBlock_ = EncasedBlock;
    class BookCategory extends Internal.AbstractReadStateHolder implements Internal.Comparable<Internal.BookCategory> {
        constructor(root: Internal.JsonObject_, id: ResourceLocation_, book: Internal.Book_)
        updateLockStatus(rootOnly: boolean): void;
        addEntry(entry: Internal.BookEntry_): void;
        compareTo(o: Internal.BookCategory_): number;
        shouldHide(): boolean;
        build(builder: Internal.BookContentsBuilder_): void;
        getDescription(): string;
        isSecret(): boolean;
        getEntries(): Internal.List<Internal.BookEntry>;
        getBook(): Internal.Book;
        compareTo(arg0: any): number;
        getIcon(): Internal.BookIcon;
        isLocked(): boolean;
        getParentCategory(): this;
        canAdd(): boolean;
        addChildCategory(category: Internal.BookCategory_): void;
        getId(): ResourceLocation;
        isRootCategory(): boolean;
        getName(): Internal.MutableComponent;
        get description(): string
        get secret(): boolean
        get entries(): Internal.List<Internal.BookEntry>
        get book(): Internal.Book
        get icon(): Internal.BookIcon
        get locked(): boolean
        get parentCategory(): Internal.BookCategory
        get id(): ResourceLocation
        get rootCategory(): boolean
        get name(): Internal.MutableComponent
    }
    type BookCategory_ = BookCategory;
    class Direction8 extends Internal.Enum<Internal.Direction8> {
        getDirections(): Internal.Set<Internal.Direction>;
        getStepX(): number;
        getStepZ(): number;
        static values(): Internal.Direction8[];
        static valueOf($$0: string): Internal.Direction8;
        get directions(): Internal.Set<Internal.Direction>
        get stepX(): number
        get stepZ(): number
        static readonly NORTH_EAST: Internal.Direction8;
        static readonly EAST: Internal.Direction8;
        static readonly NORTH_WEST: Internal.Direction8;
        static readonly SOUTH_EAST: Internal.Direction8;
        static readonly SOUTH_WEST: Internal.Direction8;
        static readonly NORTH: Internal.Direction8;
        static readonly SOUTH: Internal.Direction8;
        static readonly WEST: Internal.Direction8;
    }
    type Direction8_ = "north_west" | "west" | "north_east" | "east" | "south_west" | "south" | "north" | Direction8 | "south_east";
    class ByteIota$ByteIotaType extends Internal.IotaType<Internal.ByteIota> {
        constructor()
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.ByteIota;
    }
    type ByteIota$ByteIotaType_ = ByteIota$ByteIotaType;
    abstract class AbstractPortableCell extends Internal.AEBasePoweredItem implements Internal.IMenuItem, Internal.DyeableLeatherItem, Internal.AEToolItem, Internal.ICellWorkbenchItem {
        constructor(menuType: Internal.MenuType_<any>, props: Internal.Item$Properties_, defaultColor: number)
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onUpgradesChanged(stack: Internal.ItemStack_, upgrades: Internal.IUpgradeInventory_): void;
        setDigSpeed(speed: number): void;
        setAttackSpeed(attackSpeed: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        hasCustomColor($$0: Internal.ItemStack_): boolean;
        abstract setFuzzyMode(arg0: Internal.ItemStack_, arg1: Internal.FuzzyMode_): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static dyeArmor($$0: Internal.ItemStack_, $$1: Internal.List_<Internal.DyeItem>): Internal.ItemStack;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setColor($$0: Internal.ItemStack_, $$1: number): void;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getConfigInventory(is: Internal.ItemStack_): Internal.ConfigInventory;
        openFromInventory(player: Internal.Player_, inventorySlot: number): boolean;
        getColor(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getMenuHost(player: Internal.Player_, inventorySlot: number, stack: Internal.ItemStack_, pos: BlockPos_): Internal.PortableCellMenuHost;
        arch$registryName(): ResourceLocation;
        abstract getRecipeId(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        static getColor(stack: Internal.ItemStack_, tintIndex: number): number;
        setArmorToughness(armorToughness: number): void;
        abstract getFuzzyMode(arg0: Internal.ItemStack_): Internal.FuzzyMode;
        insert(player: Internal.Player_, stack: Internal.ItemStack_, what: Internal.AEKey_, allowed: Internal.AEKeyType_, amount: number, mode: Internal.Actionable_): number;
        getUpgrades(is: Internal.ItemStack_): Internal.IUpgradeInventory;
        emi(amount: number): Internal.EmiStack;
        clearColor($$0: Internal.ItemStack_): void;
        isEditable(is: Internal.ItemStack_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        get recipeId(): ResourceLocation
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type AbstractPortableCell_ = AbstractPortableCell;
    abstract class AbstractByteBufAllocator implements Internal.ByteBufAllocator {
        compositeDirectBuffer(arg0: number): Internal.CompositeByteBuf;
        directBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        buffer(): Internal.ByteBuf;
        compositeHeapBuffer(arg0: number): Internal.CompositeByteBuf;
        heapBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        compositeBuffer(): Internal.CompositeByteBuf;
        compositeDirectBuffer(): Internal.CompositeByteBuf;
        ioBuffer(): Internal.ByteBuf;
        heapBuffer(): Internal.ByteBuf;
        heapBuffer(arg0: number): Internal.ByteBuf;
        ioBuffer(arg0: number): Internal.ByteBuf;
        compositeBuffer(arg0: number): Internal.CompositeByteBuf;
        directBuffer(): Internal.ByteBuf;
        abstract isDirectBufferPooled(): boolean;
        directBuffer(arg0: number): Internal.ByteBuf;
        calculateNewCapacity(arg0: number, arg1: number): number;
        buffer(arg0: number, arg1: number): Internal.ByteBuf;
        ioBuffer(arg0: number, arg1: number): Internal.ByteBuf;
        compositeHeapBuffer(): Internal.CompositeByteBuf;
        buffer(arg0: number): Internal.ByteBuf;
        get directBufferPooled(): boolean
    }
    type AbstractByteBufAllocator_ = AbstractByteBufAllocator;
    interface DoubleToIntFunction {
        abstract applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type DoubleToIntFunction_ = DoubleToIntFunction;
    class HairBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type HairBlock_ = HairBlock;
    class RenderContext implements Internal.Cloneable {
        constructor(arg0: Internal.AffineTransform_, arg1: Internal.Shape_)
        constructor(arg0: Internal.AffineTransform_)
        constructor(arg0: Internal.AffineTransform_, arg1: Internal.RenderingHints_)
        constructor(arg0: Internal.AffineTransform_, arg1: Internal.Shape_, arg2: Internal.RenderingHints_)
        clone(): any;
        setTransform(arg0: Internal.AffineTransform_): void;
        /**
         * @deprecated
        */
        preConcetenateTransform(arg0: Internal.AffineTransform_): void;
        getAreaOfInterest(): Internal.Shape;
        setRenderingHints(arg0: Internal.RenderingHints_): void;
        preConcatenateTransform(arg0: Internal.AffineTransform_): void;
        concatenateTransform(arg0: Internal.AffineTransform_): void;
        /**
         * @deprecated
        */
        concetenateTransform(arg0: Internal.AffineTransform_): void;
        setAreaOfInterest(arg0: Internal.Shape_): void;
        getTransform(): Internal.AffineTransform;
        getRenderingHints(): Internal.RenderingHints;
        set transform(arg0: Internal.AffineTransform_)
        get areaOfInterest(): Internal.Shape
        set renderingHints(arg0: Internal.RenderingHints_)
        set areaOfInterest(arg0: Internal.Shape_)
        get transform(): Internal.AffineTransform
        get renderingHints(): Internal.RenderingHints
    }
    type RenderContext_ = RenderContext;
    interface ITurtleUpgrade extends Internal.UpgradeBase {
        abstract getType(): Internal.TurtleUpgradeType;
        getPersistedData(upgradeData: Internal.CompoundTag_): Internal.CompoundTag;
        abstract getUpgradeID(): ResourceLocation;
        useTool(turtle: Internal.ITurtleAccess_, side: Internal.TurtleSide_, verb: Internal.TurtleVerb_, direction: Internal.Direction_): Internal.TurtleCommandResult;
        abstract getCraftingItem(): Internal.ItemStack;
        getUpgradeData(stack: Internal.ItemStack_): Internal.CompoundTag;
        getDefaultAdjective(id: ResourceLocation_): string;
        createPeripheral(turtle: Internal.ITurtleAccess_, side: Internal.TurtleSide_): Internal.IPeripheral;
        update(turtle: Internal.ITurtleAccess_, side: Internal.TurtleSide_): void;
        isItemSuitable(stack: Internal.ItemStack_): boolean;
        getUpgradeItem(upgradeData: Internal.CompoundTag_): Internal.ItemStack;
        abstract getUnlocalisedAdjective(): string;
        get type(): Internal.TurtleUpgradeType
        get upgradeID(): ResourceLocation
        get craftingItem(): Internal.ItemStack
        get unlocalisedAdjective(): string
    }
    type ITurtleUpgrade_ = ITurtleUpgrade;
    interface Paint extends Internal.Transparency {
        abstract createContext(arg0: Internal.ColorModel_, arg1: Internal.Rectangle_, arg2: Internal.Rectangle2D_, arg3: Internal.AffineTransform_, arg4: Internal.RenderingHints_): Internal.PaintContext;
        abstract getTransparency(): number;
        get transparency(): number
    }
    type Paint_ = Paint;
    class ChainConveyorRoutingTable {
        constructor()
        receivePortInfo(filter: string, connection: BlockPos_): void;
        advertiseTo(connection: BlockPos_, otherTable: Internal.ChainConveyorRoutingTable_): void;
        createSummary(): Internal.Collection<net.minecraft.network.chat.Component>;
        shouldAdvertise(): boolean;
        tick(): void;
        getExitFor(box: Internal.ItemStack_): BlockPos;
        static readonly ENTRY_TIMEOUT: 100;
        entriesByDistance: Internal.List<Internal.ChainConveyorRoutingTable$RoutingTableEntry>;
        lastUpdate: number;
        changed: boolean;
        static readonly PORT_ENTRY_TIMEOUT: 20;
    }
    type ChainConveyorRoutingTable_ = ChainConveyorRoutingTable;
    class CustomShapelessRecipe$Serialiser <T extends Internal.CustomShapelessRecipe> extends Internal.Record implements Internal.RecipeSerializer<T> {
        factory(): Internal.CustomShapelessRecipe$Factory<Internal.DataResult<T>>;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork(id: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): T;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: T): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type CustomShapelessRecipe$Serialiser_<T extends Internal.CustomShapelessRecipe> = CustomShapelessRecipe$Serialiser<T>;
    class ScatteredOreFeature extends Internal.Feature<Internal.OreConfiguration> {
    }
    type ScatteredOreFeature_ = ScatteredOreFeature;
    class LargeCreateStyle0100BogeyBlock extends Internal.LargeBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type LargeCreateStyle0100BogeyBlock_ = LargeCreateStyle0100BogeyBlock;
    class GlobalTrainDisplayData$TrainDeparturePrediction implements Internal.Comparable<Internal.GlobalTrainDisplayData$TrainDeparturePrediction> {
        constructor(train: Internal.Train_, ticks: number, scheduleTitle: Internal.MutableComponent_, destination: string)
        compareTo(o: Internal.GlobalTrainDisplayData$TrainDeparturePrediction_): number;
        compareTo(arg0: any): number;
        ticks: number;
        scheduleTitle: Internal.MutableComponent;
        destination: string;
        train: Internal.Train;
    }
    type GlobalTrainDisplayData$TrainDeparturePrediction_ = GlobalTrainDisplayData$TrainDeparturePrediction;
    class BlockEmptyImpetus extends Internal.BlockCircleComponent {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type BlockEmptyImpetus_ = BlockEmptyImpetus;
    class EntityTypeIota extends Internal.Iota {
        constructor(entityType: Internal.EntityType_<any>)
        getEntityType(): Internal.EntityType<any>;
        get entityType(): Internal.EntityType<any>
        static TYPE: Internal.EntityTypeIota$1;
    }
    type EntityTypeIota_ = EntityTypeIota;
    class AnimationController$State extends Internal.Enum<Internal.AnimationController$State> {
        static values(): Internal.AnimationController$State[];
        static valueOf(name: string): Internal.AnimationController$State;
        static readonly TRANSITIONING: Internal.AnimationController$State;
        static readonly PAUSED: Internal.AnimationController$State;
        static readonly RUNNING: Internal.AnimationController$State;
        static readonly STOPPED: Internal.AnimationController$State;
    }
    type AnimationController$State_ = "transitioning" | "paused" | AnimationController$State | "stopped" | "running";
    interface VerticalAnchor {
        aboveBottom($$0: number): this;
        absolute($$0: number): this;
        belowTop($$0: number): this;
        bottom(): this;
        top(): this;
        abstract resolveY(arg0: Internal.WorldGenerationContext_): number;
        (arg0: Internal.WorldGenerationContext): number;
        readonly BOTTOM: Internal.VerticalAnchor$AboveBottom;
        readonly CODEC: Internal.Codec<Internal.VerticalAnchor>;
        readonly TOP: Internal.VerticalAnchor$BelowTop;
    }
    type VerticalAnchor_ = VerticalAnchor;
    abstract class Toolkit {
        getMenuShortcutKeyMaskEx(): number;
        getSystemSelection(): Internal.Clipboard;
        static getProperty(arg0: string, arg1: string): string;
        abstract mapInputMethodHighlight(arg0: Internal.InputMethodHighlight_): Internal.Map<Internal.TextAttribute, any>;
        createCustomCursor(arg0: Internal.Image_, arg1: Internal.Point_, arg2: string): Internal.Cursor;
        isDynamicLayoutActive(): boolean;
        getBestCursorSize(arg0: number, arg1: number): Internal.Dimension;
        getPropertyChangeListeners(): Internal.PropertyChangeListener[];
        abstract createImage(arg0: number[], arg1: number, arg2: number): Internal.Image;
        isAlwaysOnTopSupported(): boolean;
        abstract createImage(arg0: Internal.ImageProducer_): Internal.Image;
        areExtraMouseButtonsEnabled(): boolean;
        getLockingKeyState(arg0: number): boolean;
        abstract checkImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: Internal.ImageObserver_): number;
        setLockingKeyState(arg0: number, arg1: boolean): void;
        createImage(arg0: number[]): Internal.Image;
        removeAWTEventListener(arg0: Internal.AWTEventListener_): void;
        abstract createImage(arg0: string): Internal.Image;
        getScreenInsets(arg0: Internal.GraphicsConfiguration_): Internal.Insets;
        removePropertyChangeListener(arg0: string, arg1: Internal.PropertyChangeListener_): void;
        abstract getImage(arg0: Internal.URL_): Internal.Image;
        abstract createImage(arg0: Internal.URL_): Internal.Image;
        abstract getImage(arg0: string): Internal.Image;
        getMaximumCursorColors(): number;
        /**
         * @deprecated
        */
        abstract getFontMetrics(arg0: Internal.Font_): Internal.FontMetrics;
        getDesktopProperty(arg0: string): any;
        getAWTEventListeners(): Internal.AWTEventListener[];
        addPropertyChangeListener(arg0: string, arg1: Internal.PropertyChangeListener_): void;
        /**
         * @deprecated
        */
        abstract getFontList(): string[];
        abstract getColorModel(): Internal.ColorModel;
        abstract isModalExclusionTypeSupported(arg0: Internal.Dialog$ModalExclusionType_): boolean;
        getSystemEventQueue(): Internal.EventQueue;
        abstract sync(): void;
        getAWTEventListeners(arg0: number): Internal.AWTEventListener[];
        abstract getPrintJob(arg0: Internal.Frame_, arg1: string, arg2: Internal.Properties_): Internal.PrintJob;
        abstract isModalityTypeSupported(arg0: Internal.Dialog$ModalityType_): boolean;
        getPropertyChangeListeners(arg0: string): Internal.PropertyChangeListener[];
        isFrameStateSupported(arg0: number): boolean;
        abstract getScreenResolution(): number;
        addAWTEventListener(arg0: Internal.AWTEventListener_, arg1: number): void;
        createDragGestureRecognizer<T extends Internal.DragGestureRecognizer>(arg0: T, arg1: Internal.DragSource_, arg2: Internal.Component_, arg3: number, arg4: Internal.DragGestureListener_): T;
        abstract beep(): void;
        abstract getScreenSize(): Internal.Dimension;
        /**
         * @deprecated
        */
        getMenuShortcutKeyMask(): number;
        static getDefaultToolkit(): Internal.Toolkit;
        setDynamicLayout(arg0: boolean): void;
        getPrintJob(arg0: Internal.Frame_, arg1: string, arg2: Internal.JobAttributes_, arg3: Internal.PageAttributes_): Internal.PrintJob;
        abstract prepareImage(arg0: Internal.Image_, arg1: number, arg2: number, arg3: Internal.ImageObserver_): boolean;
        abstract getSystemClipboard(): Internal.Clipboard;
        get menuShortcutKeyMaskEx(): number
        get systemSelection(): Internal.Clipboard
        get dynamicLayoutActive(): boolean
        get propertyChangeListeners(): Internal.PropertyChangeListener[]
        get alwaysOnTopSupported(): boolean
        get maximumCursorColors(): number
        get AWTEventListeners(): Internal.AWTEventListener[]
        /**
         * @deprecated
        */
        get fontList(): string[]
        get colorModel(): Internal.ColorModel
        get systemEventQueue(): Internal.EventQueue
        get screenResolution(): number
        get screenSize(): Internal.Dimension
        /**
         * @deprecated
        */
        get menuShortcutKeyMask(): number
        get defaultToolkit(): Internal.Toolkit
        set dynamicLayout(arg0: boolean)
        get systemClipboard(): Internal.Clipboard
    }
    type Toolkit_ = Toolkit;
    class MushroomColonyBlock extends Internal.BushBlock implements Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, mushroomType: Internal.Supplier_<Internal.Item>)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess(level: Internal.Level_, random: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(level: Internal.ServerLevel_, random: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(level: Internal.LevelReader_, pos: BlockPos_, state: Internal.BlockState_, isClient: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getAgeProperty(): Internal.IntegerProperty;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getMaxAge(): number;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get ageProperty(): Internal.IntegerProperty
        get maxAge(): number
        static readonly COLONY_AGE: Internal.IntegerProperty;
        readonly mushroomType: Internal.Supplier<Internal.Item>;
        static readonly PLACING_LIGHT_LEVEL: 13;
    }
    type MushroomColonyBlock_ = MushroomColonyBlock;
    class SampleDrillBlock extends Internal.Block implements Internal.IBE<Internal.SampleDrillBlockEntity> {
        constructor(p_49224_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SampleDrillBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SampleDrillBlockEntity>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SampleDrillBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getBlockEntityClass(): typeof Internal.SampleDrillBlockEntity;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SampleDrillBlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SampleDrillBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get blockEntityType(): Internal.BlockEntityType<Internal.SampleDrillBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.SampleDrillBlockEntity
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type SampleDrillBlock_ = SampleDrillBlock;
    class CratersDensityFunction extends Internal.BlendedNoise {
        constructor(scale: number)
        constructor(randomSource: Internal.RandomSource_, scale: number)
        halfNegative(): Internal.DensityFunction;
        abs(): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray($$0: number[], $$1: Internal.DensityFunction$ContextProvider_): void;
        squeeze(): Internal.DensityFunction;
        square(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp($$0: number, $$1: number): Internal.DensityFunction;
        static readonly CODEC: Internal.KeyDispatchDataCodec<Internal.CratersDensityFunction>;
    }
    type CratersDensityFunction_ = CratersDensityFunction;
    class SignalBlock extends Internal.Block implements Internal.WeakPowerCheckingBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.SignalBlockEntity> {
        constructor(p_53182_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SignalBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SignalBlockEntity>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SignalBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityClass(): typeof Internal.SignalBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SignalBlockEntity>;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SignalBlockEntity>): void;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.SignalBlockEntity>
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.SignalBlockEntity
        static readonly TYPE: Internal.EnumProperty<Internal.SignalBlock$SignalType>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type SignalBlock_ = SignalBlock;
    interface ItemApiLookup$ItemApiProvider <A, C> {
        abstract find(arg0: Internal.ItemStack_, arg1: C): A;
        (arg0: Internal.ItemStack, arg1: C): A;
    }
    type ItemApiLookup$ItemApiProvider_<A, C> = ItemApiLookup$ItemApiProvider<A, C>;
    abstract class FieldNamingPolicy extends Internal.Enum<Internal.FieldNamingPolicy> implements Internal.FieldNamingStrategy {
        abstract translateName(arg0: Internal.Field_): string;
        static valueOf(arg0: string): Internal.FieldNamingPolicy;
        static values(): Internal.FieldNamingPolicy[];
        static readonly UPPER_CASE_WITH_UNDERSCORES: Internal.FieldNamingPolicy;
        static readonly IDENTITY: Internal.FieldNamingPolicy;
        static readonly UPPER_CAMEL_CASE: Internal.FieldNamingPolicy;
        static readonly LOWER_CASE_WITH_UNDERSCORES: Internal.FieldNamingPolicy;
        static readonly LOWER_CASE_WITH_DASHES: Internal.FieldNamingPolicy;
        static readonly UPPER_CAMEL_CASE_WITH_SPACES: Internal.FieldNamingPolicy;
        static readonly LOWER_CASE_WITH_DOTS: Internal.FieldNamingPolicy;
    }
    type FieldNamingPolicy_ = "lower_case_with_underscores" | "lower_case_with_dashes" | "identity" | "upper_camel_case_with_spaces" | "lower_case_with_dots" | "upper_case_with_underscores" | FieldNamingPolicy | "upper_camel_case";
    class GenericDyeableSingleBufferBlock extends Internal.AbstractDyeableSingleBufferBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, shaper: Internal.VoxelShaper_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        static createFactory(shaper: Internal.VoxelShaper_): com.tterrag.registrate.util.nullness.NonNullFunction<Internal.BlockBehaviour$Properties, Internal.GenericDyeableSingleBufferBlock>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.DyeableBlockEntity>): void;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.DyeableBlockEntity;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.DyeableBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.DyeableBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type GenericDyeableSingleBufferBlock_ = GenericDyeableSingleBufferBlock;
    interface ItemTintFunction {
        abstract getColor(arg0: Internal.ItemStack_, arg1: number): dev.latvian.mods.rhino.mod.util.color.Color;
        of(cx: Internal.Context_, o: any): this;
        (arg0: Internal.ItemStack, arg1: number): dev.latvian.mods.rhino.mod.util.color.Color_;
        readonly POTION: Internal.ItemTintFunction;
        readonly DISPLAY_COLOR_NBT: Internal.ItemTintFunction;
        readonly BLOCK: Internal.ItemTintFunction;
        readonly MAP: Internal.ItemTintFunction;
    }
    type ItemTintFunction_ = ItemTintFunction;
    class PusBubbleBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static spawnParticles(p_55480_: Internal.Level_, pos: BlockPos_): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type PusBubbleBlock_ = PusBubbleBlock;
    class SnowAndFreezeFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type SnowAndFreezeFeature_ = SnowAndFreezeFeature;
    interface IMixinVineBlock {
        abstract invokeShouldConnectUp(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        (arg0: Internal.BlockGetter, arg1: BlockPos, arg2: Internal.Direction): boolean;
    }
    type IMixinVineBlock_ = IMixinVineBlock;
    class IntConfig extends Internal.NumberConfig<number> {
        constructor(mn: number, mx: number)
        scrollValue(currentValue: number, forward: boolean): Internal.Optional<number>;
        scrollValue(arg0: any, arg1: boolean): Internal.Optional<any>;
    }
    type IntConfig_ = IntConfig;
    class StormStrikeEnchantment extends Internal.Enchantment {
        constructor()
        registryName(): string;
    }
    type StormStrikeEnchantment_ = StormStrikeEnchantment;
    class PrintStream extends Internal.FilterOutputStream implements Internal.Closeable, Internal.Appendable {
        constructor(arg0: Internal.File_)
        constructor(arg0: Internal.OutputStream_, arg1: boolean)
        constructor(arg0: Internal.OutputStream_)
        constructor(arg0: string, arg1: string)
        constructor(arg0: string, arg1: Internal.Charset_)
        constructor(arg0: Internal.File_, arg1: Internal.Charset_)
        constructor(arg0: Internal.OutputStream_, arg1: boolean, arg2: Internal.Charset_)
        constructor(arg0: Internal.OutputStream_, arg1: boolean, arg2: string)
        constructor(arg0: string)
        constructor(arg0: Internal.File_, arg1: string)
        print(arg0: string): void;
        println(arg0: number): void;
        println(): void;
        printf(arg0: string, ...arg1: any[]): this;
        format(arg0: Internal.Locale_, arg1: string, ...arg2: any[]): this;
        println(arg0: number): void;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): Internal.Appendable;
        append(arg0: string): Internal.Appendable;
        print(arg0: number): void;
        println(arg0: string): void;
        print(arg0: number): void;
        format(arg0: string, ...arg1: any[]): this;
        print(arg0: boolean): void;
        print(arg0: number): void;
        println(arg0: string): void;
        println(arg0: string[]): void;
        println(arg0: boolean): void;
        append(arg0: Internal.CharSequence_): Internal.Appendable;
        printf(arg0: Internal.Locale_, arg1: string, ...arg2: any[]): this;
        charset(): Internal.Charset;
        println(arg0: number): void;
        println(arg0: number): void;
        checkError(): boolean;
        print(arg0: string[]): void;
        print(arg0: any): void;
        print(arg0: string): void;
        writeBytes(arg0: number[]): void;
        print(arg0: number): void;
        println(arg0: any): void;
    }
    type PrintStream_ = PrintStream;
    interface IEnergyStorageUpgradeWrapper {
        abstract wrapStorage(arg0: Internal.EnergyStorage_): Internal.EnergyStorage;
        (arg0: Internal.EnergyStorage): Internal.EnergyStorage_;
    }
    type IEnergyStorageUpgradeWrapper_ = IEnergyStorageUpgradeWrapper;
    class WireSpool extends Internal.Item {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getPos(nbt: Internal.CompoundTag_): BlockPos;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        static getNode(nbt: Internal.CompoundTag_): number;
        setAttackDamage(attackDamage: number): void;
        static setContent(nbt: Internal.CompoundTag_, pos: BlockPos_, node: number): Internal.CompoundTag;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static hasPos(nbt: Internal.CompoundTag_): boolean;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static isRemover(item: Internal.Item_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type WireSpool_ = WireSpool;
    /**
     * Invoked when a player right clicks on an entity.
    */
    class ItemEntityInteractedEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.Player_, entity: Internal.Entity_, hand: Internal.InteractionHand_)
        /**
         * The entity that was interacted with.
        */
        getTarget(): Internal.Entity;
        /**
         * The player that interacted with the entity.
        */
        getEntity(): Internal.Entity;
        /**
         * The item that was used to interact with the entity.
        */
        getItem(): Internal.ItemStack;
        /**
         * The hand that was used to interact with the entity.
        */
        getHand(): Internal.InteractionHand;
        /**
         * The entity that was interacted with.
        */
        get target(): Internal.Entity
        /**
         * The player that interacted with the entity.
        */
        get entity(): Internal.Entity
        /**
         * The item that was used to interact with the entity.
        */
        get item(): Internal.ItemStack
        /**
         * The hand that was used to interact with the entity.
        */
        get hand(): Internal.InteractionHand
    }
    type ItemEntityInteractedEventJS_ = ItemEntityInteractedEventJS;
    class ModuleDescriptor$Builder {
        version(arg0: string): this;
        opens(arg0: Internal.Set_<Internal.ModuleDescriptor$Opens$Modifier>, arg1: string, arg2: Internal.Set_<string>): this;
        requires(arg0: Internal.ModuleDescriptor$Requires_): this;
        requires(arg0: Internal.Set_<Internal.ModuleDescriptor$Requires$Modifier>, arg1: string): this;
        requires(arg0: string): this;
        version(arg0: Internal.ModuleDescriptor$Version_): this;
        provides(arg0: string, arg1: Internal.List_<string>): this;
        opens(arg0: Internal.Set_<Internal.ModuleDescriptor$Opens$Modifier>, arg1: string): this;
        mainClass(arg0: string): this;
        packages(arg0: Internal.Set_<string>): this;
        exports(arg0: Internal.ModuleDescriptor$Exports_): this;
        opens(arg0: string): this;
        opens(arg0: string, arg1: Internal.Set_<string>): this;
        requires(arg0: Internal.Set_<Internal.ModuleDescriptor$Requires$Modifier>, arg1: string, arg2: Internal.ModuleDescriptor$Version_): this;
        opens(arg0: Internal.ModuleDescriptor$Opens_): this;
        build(): Internal.ModuleDescriptor;
        provides(arg0: Internal.ModuleDescriptor$Provides_): this;
        uses(arg0: string): this;
        exports(arg0: Internal.Set_<Internal.ModuleDescriptor$Exports$Modifier>, arg1: string, arg2: Internal.Set_<string>): this;
        exports(arg0: string): this;
        exports(arg0: Internal.Set_<Internal.ModuleDescriptor$Exports$Modifier>, arg1: string): this;
        exports(arg0: string, arg1: Internal.Set_<string>): this;
    }
    type ModuleDescriptor$Builder_ = ModuleDescriptor$Builder;
    interface BiomeProperties {
        abstract getEffectsProperties(): Internal.EffectsProperties;
        abstract getClimateProperties(): Internal.ClimateProperties;
        abstract getGenerationProperties(): Internal.GenerationProperties;
        abstract getSpawnProperties(): Internal.SpawnProperties;
        get effectsProperties(): Internal.EffectsProperties
        get climateProperties(): Internal.ClimateProperties
        get generationProperties(): Internal.GenerationProperties
        get spawnProperties(): Internal.SpawnProperties
    }
    type BiomeProperties_ = BiomeProperties;
    class LeafPileBlock extends Internal.BushBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type LeafPileBlock_ = LeafPileBlock;
    class CropBlockBuilder extends Internal.BlockBuilder {
        constructor(i: ResourceLocation_)
        growTick(growSpeedCallback: Internal.ToDoubleFunction_<Internal.RandomTickCallbackJS>): this;
        /**
         * Set if the crop should drop seeds when harvested.
        */
        dropSeed(dropSeed: boolean): this;
        bonemeal(bonemealCallback: Internal.ToIntFunction_<Internal.RandomTickCallbackJS>): this;
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
        /**
         * Set the age of the crop and the shape of the crop at that age.
        */
        age(age: number, builder: Internal.Consumer_<Internal.CropBlockBuilder$ShapeBuilder>): this;
        /**
         * Add a crop output with a specific chance.
        */
        crop(output: any, chance: number): this;
        /**
         * Set the age of the crop. Note that the box will be the same for all ages (A full block size).
        */
        age(age: number): this;
        survive(surviveCallback: Internal.CropBlockBuilder$SurviveCallback_): this;
        /**
         * Add a crop output with a 100% chance.
        */
        crop(output: any): this;
    }
    type CropBlockBuilder_ = CropBlockBuilder;
    interface CommandBuildContext {
        abstract holderLookup<T>(arg0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        simple($$0: Internal.HolderLookup$Provider_, $$1: Internal.FeatureFlagSet_): this;
        configurable($$0: Internal.RegistryAccess_, $$1: Internal.FeatureFlagSet_): Internal.CommandBuildContext$Configurable;
        (arg0: Internal.ResourceKey<Internal.Registry<T>>): Internal.HolderLookup_<T>;
    }
    type CommandBuildContext_ = CommandBuildContext;
    class Tesselator implements Internal.MixinSetTessBuffer {
        constructor()
        constructor($$0: number)
        getBuilder(): Internal.BufferBuilder;
        end(): void;
        static getInstance(): Internal.Tesselator;
        static setInstance$inline_$md$fca01f$0(arg0: Internal.Tesselator_): void;
        static setInstance(tes: Internal.Tesselator_): void;
        get builder(): Internal.BufferBuilder
        get instance(): Internal.Tesselator
        set instance$inline_$md$fca01f$0(arg0: Internal.Tesselator_)
        set instance(tes: Internal.Tesselator_)
    }
    type Tesselator_ = Tesselator;
    abstract class StarFluid extends Internal.DirectionalFluid {
        constructor(flowDirection: Internal.Direction_)
        getSplashSound(entity: Internal.Entity_): Internal.SoundEvent;
        canBreathe(entity: Internal.LivingEntity_): boolean;
        canWalkOn(entity: Internal.LivingEntity_, movementInput: Vec3d_, state: Internal.FluidState_): boolean;
        onSwimmingStart(entity: Internal.Entity_): void;
        calculateSubmergedVisibility(player: Internal.Player_, currentVisibilityTicks: number): number;
        knockInFlowDirection(entity: Internal.Entity_): void;
        abstract getBubbleParticle(arg0: Internal.Entity_): Internal.ParticleOptions;
        travelInFluid(entity: Internal.LivingEntity_, movementInput: Vec3d_, gravity: number, falling: boolean): void;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        getHighSpeedSplashSound(entity: Internal.Entity_): Internal.SoundEvent;
        abstract getSplashParticle(arg0: Internal.Entity_): Internal.ParticleOptions;
        arch$registryName(): ResourceLocation;
        swim(entity: Internal.LivingEntity_): void;
    }
    type StarFluid_ = StarFluid;
    abstract class AbstractHorse extends Internal.Animal implements Internal.AbstractHorseAccess, Internal.HasCustomInventoryScreen, Internal.Saddleable, Internal.OwnableEntity, net.minecraft.world.ContainerListener, Internal.PlayerRideableJumping {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        isBred(): boolean;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getInventory(): Internal.SimpleContainer;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        canJump(): boolean;
        swing(): void;
        isArmor($$0: Internal.ItemStack_): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        getMaxTemper(): number;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        fedFood($$0: Internal.Player_, $$1: Internal.ItemStack_): Internal.InteractionResult;
        setTemper($$0: number): void;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): net.minecraft.network.chat.Component;
        isWearingArmor(): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getTemper(): number;
        getJumpCooldown(): number;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        tameWithName($$0: Internal.Player_): boolean;
        canWearArmor(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        hasInventoryChanged($$0: net.minecraft.world.Container_): boolean;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        setOwnerUUID($$0: Internal.UUID_): void;
        getAmbientStandSound(): Internal.SoundEvent;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setStanding($$0: boolean): void;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        handleStartJump($$0: number): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        method_6062(): boolean;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getOwnerUUID(): Internal.UUID;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        static createBaseHorseAttributes(): Internal.AttributeSupplier$Builder;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isEating(): boolean;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        handleStopJump(): void;
        getEatAnim($$0: number): number;
        getMouthAnim($$0: number): number;
        getType(): string;
        makeMad(): void;
        setBred($$0: boolean): void;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        isSaddled(): boolean;
        setTotalMovementSpeedMultiplier(speed: number): void;
        standIfPossible(): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getAmbientStandInterval(): number;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        isSaddleable(): boolean;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        canEatGrass(): boolean;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        openCustomInventoryScreen($$0: Internal.Player_): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        equipSaddle($$0: Internal.SoundSource_): void;
        getCustomJump(): number;
        level(): Internal.EntityGetter;
        isJumping(): boolean;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        equipArmor($$0: Internal.Player_, $$1: Internal.ItemStack_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        setEating($$0: boolean): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        onPlayerJump($$0: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        modifyTemper($$0: number): number;
        setZ(z: number): void;
        isTamed(): boolean;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getStandAnim($$0: number): number;
        setIsJumping($$0: boolean): void;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setTamed($$0: boolean): void;
        containerChanged($$0: net.minecraft.world.Container_): void;
        runCommand(command: string): number;
        isStanding(): boolean;
        get bred(): boolean
        get inventory(): Internal.SimpleContainer
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        get maxTemper(): number
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        set temper($$0: number)
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): net.minecraft.network.chat.Component
        get wearingArmor(): boolean
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get temper(): number
        get jumpCooldown(): number
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        set ownerUUID($$0: Internal.UUID_)
        get ambientStandSound(): Internal.SoundEvent
        get frame(): boolean
        set standing($$0: boolean)
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get ownerUUID(): Internal.UUID
        get undead(): boolean
        get eating(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set bred($$0: boolean)
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get saddled(): boolean
        set totalMovementSpeedMultiplier(speed: number)
        get ambientStandInterval(): number
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get saddleable(): boolean
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get customJump(): number
        get jumping(): boolean
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        set eating($$0: boolean)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        get tamed(): boolean
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set isJumping($$0: boolean)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set tamed($$0: boolean)
        get standing(): boolean
        static readonly MAX_JUMP_STRENGTH: 1.0;
        static readonly BREEDING_CROSS_FACTOR: 0.15;
        playerJumpPendingScale: number;
        static readonly CHEST_SLOT_OFFSET: 499;
        static readonly MAX_MOVEMENT_SPEED: 0.3375;
        static readonly INV_SLOT_ARMOR: 1;
        sprintCounter: number;
        static FOOD_ITEMS: Internal.Ingredient;
        static readonly INVENTORY_SLOT_OFFSET: 500;
        tailCounter: number;
        static readonly INV_BASE_COUNT: 2;
        static readonly INV_SLOT_SADDLE: 0;
        static readonly EQUIPMENT_SLOT_OFFSET: 400;
    }
    type AbstractHorse_ = AbstractHorse;
    class FabricEntityTypeBuilder$Living <T extends Internal.LivingEntity> extends Internal.FabricEntityTypeBuilder<T> {
        disableSummon(): Internal.FabricEntityTypeBuilder<any>;
        /**
         * @deprecated
        */
        trackable(trackRangeBlocks: number, trackedUpdateRate: number): this;
        trackedUpdateRate(arg0: number): Internal.FabricEntityTypeBuilder<any>;
        forceTrackedVelocityUpdates(forceTrackedVelocityUpdates: boolean): this;
        fireImmune(): Internal.FabricEntityTypeBuilder<any>;
        defaultAttributes(defaultAttributeBuilder: Internal.Supplier_<Internal.AttributeSupplier$Builder>): this;
        specificSpawnBlocks(arg0: Internal.Block_[]): Internal.FabricEntityTypeBuilder<any>;
        spawnableFarFromPlayer(): Internal.FabricEntityTypeBuilder<any>;
        trackRangeChunks(arg0: number): Internal.FabricEntityTypeBuilder<any>;
        trackRangeBlocks(arg0: number): Internal.FabricEntityTypeBuilder<any>;
        spawnGroup(arg0: Internal.MobCategory_): Internal.FabricEntityTypeBuilder<any>;
        entityFactory<N extends T>(factory: Internal.EntityType$EntityFactory_<N>): Internal.FabricEntityTypeBuilder$Living<N>;
        build(): Internal.EntityType<T>;
        dimensions(dimensions: Internal.EntityDimensions_): this;
        /**
         * @deprecated
        */
        trackable(trackRangeBlocks: number, trackedUpdateRate: number, forceTrackedVelocityUpdates: boolean): this;
        disableSaving(): Internal.FabricEntityTypeBuilder<any>;
    }
    type FabricEntityTypeBuilder$Living_<T extends Internal.LivingEntity> = FabricEntityTypeBuilder$Living<T>;
    abstract class ChunkRenderDispatcher$RenderChunk$ChunkCompileTask implements Internal.Comparable<Internal.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask> {
        constructor(arg0: Internal.ChunkRenderDispatcher$RenderChunk_, arg1: number, arg2: boolean)
        compareTo($$0: Internal.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask_): number;
        abstract cancel(): void;
        abstract doTask(arg0: Internal.ChunkBufferBuilderPack_): Internal.CompletableFuture<Internal.ChunkRenderDispatcher$ChunkTaskResult>;
        compareTo(arg0: any): number;
    }
    type ChunkRenderDispatcher$RenderChunk$ChunkCompileTask_ = ChunkRenderDispatcher$RenderChunk$ChunkCompileTask;
    abstract class RetexturedTableBlock extends Internal.TabbedTableBlock implements Internal.BlockPickInteractionAware {
        constructor(builder: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, result: Internal.HitResult_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type RetexturedTableBlock_ = RetexturedTableBlock;
    class TrackGraphBounds {
        constructor(graph: Internal.TrackGraph_, dimension: Internal.ResourceKey_<Internal.Level>)
        beziers: Internal.List<Internal.BezierConnection>;
        box: Internal.AABB;
    }
    type TrackGraphBounds_ = TrackGraphBounds;
    interface ChunkTracker$ChunkEventHandler {
        abstract apply(arg0: number, arg1: number): void;
        (arg0: number, arg1: number): void;
    }
    type ChunkTracker$ChunkEventHandler_ = ChunkTracker$ChunkEventHandler;
    class RealmsDataFetcher {
        constructor($$0: Internal.RealmsClient_)
        readonly newsManager: Internal.RealmsNewsManager;
        readonly serverListUpdateTask: Internal.DataFetcher$Task<Internal.List<Internal.RealmsServer>>;
        readonly notificationsTask: Internal.DataFetcher$Task<Internal.List<Internal.RealmsNotification>>;
        readonly newsTask: Internal.DataFetcher$Task<Internal.RealmsNews>;
        readonly dataFetcher: Internal.DataFetcher;
        readonly liveStatsTask: Internal.DataFetcher$Task<Internal.RealmsServerPlayerLists>;
        readonly trialAvailabilityTask: Internal.DataFetcher$Task<boolean>;
        readonly pendingInvitesTask: Internal.DataFetcher$Task<number>;
    }
    type RealmsDataFetcher_ = RealmsDataFetcher;
    interface FocusListener extends Internal.EventListener {
        abstract focusGained(arg0: Internal.FocusEvent_): void;
        abstract focusLost(arg0: Internal.FocusEvent_): void;
    }
    type FocusListener_ = FocusListener;
    class MoltenCopperFluid$Flowing extends Internal.MoltenCopperFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenCopperFluid$Flowing_ = MoltenCopperFluid$Flowing;
    class MessageSignatureCache {
        constructor($$0: number)
        static createDefault(): Internal.MessageSignatureCache;
        unpack($$0: number): Internal.MessageSignature;
        pack($$0: Internal.MessageSignature_): number;
        push($$0: Internal.PlayerChatMessage_): void;
        static readonly NOT_FOUND: -1;
    }
    type MessageSignatureCache_ = MessageSignatureCache;
    class MeltingFuel implements Internal.ICustomOutputRecipe<Internal.IFluidContainer> {
        constructor(id: ResourceLocation_, group: string, input: slimeknights.mantle.recipe.ingredient.FluidIngredient_, duration: number, temperature: number)
        getInputs(): Internal.List<Internal.FluidStack>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getAmount(fluid: Internal.Fluid_): number;
        /**
         * @deprecated
        */
        assemble(inv: Internal.IFluidContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getSerializer(): Internal.RecipeSerializer<any>;
        getAmount(inv: Internal.IFluidContainer_): number;
        getId(): ResourceLocation;
        matches(inv: Internal.IFluidContainer_, worldIn: Internal.Level_): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        getRemainingItems($$0: Internal.IFluidContainer_): Internal.NonNullList<Internal.ItemStack>;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getTemperature(): number;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        matches(fluid: Internal.Fluid_): boolean;
        getDuration(): number;
        get inputs(): Internal.List<Internal.FluidStack>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get temperature(): number
        get duration(): number
    }
    type MeltingFuel_ = MeltingFuel;
    class Direction$AxisDirection extends Internal.Enum<Internal.Direction$AxisDirection> {
        opposite(): this;
        static values(): Internal.Direction$AxisDirection[];
        getStep(): number;
        getName(): string;
        static valueOf($$0: string): Internal.Direction$AxisDirection;
        get step(): number
        get name(): string
        static readonly POSITIVE: Internal.Direction$AxisDirection;
        static readonly NEGATIVE: Internal.Direction$AxisDirection;
    }
    type Direction$AxisDirection_ = "negative" | "positive" | Direction$AxisDirection;
    interface ToNumberStrategy {
        abstract readNumber(arg0: Internal.JsonReader_): number;
        (arg0: Internal.JsonReader): number;
    }
    type ToNumberStrategy_ = ToNumberStrategy;
    class HotSpringVentFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type HotSpringVentFeature_ = HotSpringVentFeature;
    class AllOfCondition$Builder extends Internal.CompositeLootItemCondition$Builder {
        constructor(...$$0: Internal.LootItemCondition$Builder_[])
        invert(): Internal.LootItemCondition$Builder;
        or($$0: Internal.LootItemCondition$Builder_): Internal.AnyOfCondition$Builder;
    }
    type AllOfCondition$Builder_ = AllOfCondition$Builder;
    class ShulkerBullet extends Internal.Projectile {
        constructor($$0: Internal.EntityType_<Internal.ShulkerBullet>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: Internal.LivingEntity_, $$2: Internal.Entity_, $$3: Internal.Direction$Axis_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type ShulkerBullet_ = ShulkerBullet;
    class LiquidEgg extends Internal.EggItem {
        constructor(fluid: Internal.Fluid_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        placeFluid(player: Internal.Player_, world: Internal.Level_, pos: BlockPos_, hitResult: Internal.BlockHitResult_): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        readonly fluidType: Internal.Fluid;
    }
    type LiquidEgg_ = LiquidEgg;
    interface ISlotChangeResponseUpgrade {
        abstract onSlotChange(arg0: Internal.SlottedStackStorage_, arg1: number): void;
        (arg0: Internal.SlottedStackStorage, arg1: number): void;
    }
    type ISlotChangeResponseUpgrade_ = ISlotChangeResponseUpgrade;
    class EmptyFluid extends Internal.Fluid {
        constructor()
        method_15777($$0: Internal.FluidState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Fluid_, $$4: Internal.Direction_): boolean;
        method_15782($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.FluidState_): Vec3d;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type EmptyFluid_ = EmptyFluid;
    interface SemanticVersion extends Internal.Version {
        /**
         * @deprecated
        */
        compareTo(arg0: Internal.SemanticVersion_): number;
        abstract getPrereleaseKey(): Internal.Optional<string>;
        abstract compareTo(arg0: Internal.Version_): number;
        abstract getVersionComponent(arg0: number): number;
        abstract getVersionComponentCount(): number;
        abstract hasWildcard(): boolean;
        abstract getBuildKey(): Internal.Optional<string>;
        parse(arg0: string): this;
        abstract getFriendlyString(): string;
        get prereleaseKey(): Internal.Optional<string>
        get versionComponentCount(): number
        get buildKey(): Internal.Optional<string>
        get friendlyString(): string
        readonly COMPONENT_WILDCARD: -2147483648;
    }
    type SemanticVersion_ = SemanticVersion;
    class CombatTracker {
        constructor($$0: Internal.LivingEntity_)
        getMostSignificantFall(): Internal.CombatEntry;
        getDeathMessage(): net.minecraft.network.chat.Component;
        recordDamage($$0: DamageSource_, $$1: number): void;
        recheckStatus(): void;
        getCombatDuration(): number;
        get mostSignificantFall(): Internal.CombatEntry
        get deathMessage(): net.minecraft.network.chat.Component
        get combatDuration(): number
        static readonly RESET_COMBAT_STATUS_TIME: 300;
        static readonly RESET_DAMAGE_STATUS_TIME: 100;
    }
    type CombatTracker_ = CombatTracker;
    interface CustomIngredient extends Internal.CustomIngredientKJS, Internal.CustomIngredientMixin {
        abstract getSerializer(): Internal.CustomIngredientSerializer<any>;
        abstract test(arg0: Internal.ItemStack_): boolean;
        kjs$canBeUsedForMatching(): boolean;
        toVanilla(): Internal.Ingredient;
        abstract getMatchingStacks(): Internal.List<Internal.ItemStack>;
        abstract requiresTesting(): boolean;
        get serializer(): Internal.CustomIngredientSerializer<any>
        get matchingStacks(): Internal.List<Internal.ItemStack>
    }
    type CustomIngredient_ = CustomIngredient;
    interface Merchant {
        abstract notifyTradeUpdated(arg0: Internal.ItemStack_): void;
        abstract notifyTrade(arg0: Internal.MerchantOffer_): void;
        abstract setTradingPlayer(arg0: Internal.Player_): void;
        abstract isClientSide(): boolean;
        abstract getTradingPlayer(): Internal.Player;
        canRestock(): boolean;
        abstract getOffers(): Internal.MerchantOffers;
        openTradingScreen($$0: Internal.Player_, $$1: net.minecraft.network.chat.Component_, $$2: number): void;
        abstract getNotifyTradeSound(): Internal.SoundEvent;
        abstract overrideXp(arg0: number): void;
        abstract overrideOffers(arg0: Internal.MerchantOffers_): void;
        abstract showProgressBar(): boolean;
        abstract getVillagerXp(): number;
        set tradingPlayer(arg0: Internal.Player_)
        get clientSide(): boolean
        get tradingPlayer(): Internal.Player
        get offers(): Internal.MerchantOffers
        get notifyTradeSound(): Internal.SoundEvent
        get villagerXp(): number
    }
    type Merchant_ = Merchant;
    interface TraceableEntity {
        abstract getOwner(): Internal.Entity;
        get owner(): Internal.Entity
        (): Internal.Entity_;
    }
    type TraceableEntity_ = TraceableEntity;
    class IdMapper <T> implements Internal.IdMap<T>, Internal.RemovableIdList<any> {
        constructor()
        constructor($$0: number)
        byId($$0: number): T;
        spliterator(): Internal.Spliterator<T>;
        contains($$0: number): boolean;
        byIdOrThrow($$0: number): T;
        iterator(): Internal.Iterator<T>;
        fabric_clear(): void;
        getId($$0: T): number;
        forEach(arg0: Internal.Consumer_<T>): void;
        size(): number;
        fabric_remapId(from: number, to: number): void;
        fabric_remapIds(map: Internal.Int2IntMap_): void;
        fabric_removeId(i: number): void;
        add($$0: T): void;
        addMapping($$0: T, $$1: number): void;
        fabric_remove(o: any): void;
    }
    type IdMapper_<T> = IdMapper<T>;
    class WorldOptions {
        constructor($$0: number, $$1: boolean, $$2: boolean)
        static defaultWithRandomSeed(): Internal.WorldOptions;
        withStructures($$0: boolean): this;
        static parseSeed($$0: string): Internal.OptionalLong;
        generateBonusChest(): boolean;
        seed(): number;
        static randomSeed(): number;
        withSeed($$0: Internal.OptionalLong_): this;
        withBonusChest($$0: boolean): this;
        isOldCustomizedWorld(): boolean;
        generateStructures(): boolean;
        get oldCustomizedWorld(): boolean
        static readonly CODEC: Internal.MapCodec<Internal.WorldOptions>;
        static readonly DEMO_OPTIONS: Internal.WorldOptions;
    }
    type WorldOptions_ = WorldOptions;
    class Creeper extends Internal.Monster implements Internal.PowerableMob {
        constructor($$0: Internal.EntityType_<Internal.Creeper>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        isIgnited(): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        getSwelling($$0: number): number;
        setY(y: number): void;
        canDropMobsSkull(): boolean;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        increaseDroppedSkulls(): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        setSwellDir($$0: number): void;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        isPowered(): boolean;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getSwellDir(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        ignite(): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get ignited(): boolean
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set swellDir($$0: number)
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get powered(): boolean
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get swellDir(): number
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        swell: number;
    }
    type Creeper_ = Creeper;
    interface Int2CharFunction extends it.unimi.dsi.fastutil.Function<number, string>, Internal.IntUnaryOperator {
        remove(arg0: number): string;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, string>;
        defaultReturnValue(): string;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2CharFunction;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Int2ShortFunction;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2CharFunction;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2CharFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        getOrDefault(arg0: number, arg1: string): string;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        applyAsInt(arg0: number): number;
        defaultReturnValue(arg0: string): void;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Int2FloatFunction;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: string): string;
        apply(arg0: number): string;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2CharFunction;
        abstract get(arg0: number): string;
        put(arg0: number, arg1: string): string;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2CharFunction<T>;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Int2ByteFunction;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Int2DoubleFunction;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2CharFunction;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2CharFunction;
        size(): number;
        clear(): void;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Int2LongFunction;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2CharFunction<T>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<number, T>;
        (arg0: number): string;
    }
    type Int2CharFunction_ = Int2CharFunction;
    abstract class Enchantment {
        getFullname($$0: number): net.minecraft.network.chat.Component;
        getDamageProtection($$0: number, $$1: DamageSource_): number;
        getRarity(): Internal.Enchantment$Rarity;
        isCompatibleWith($$0: Internal.Enchantment_): boolean;
        isTradeable(): boolean;
        getMaxLevel(): number;
        doPostAttack($$0: Internal.LivingEntity_, $$1: Internal.Entity_, $$2: number): void;
        isTreasureOnly(): boolean;
        getSlotItems($$0: Internal.LivingEntity_): Internal.Map<Internal.EquipmentSlot, Internal.ItemStack>;
        getMinLevel(): number;
        getDamageBonus($$0: number, $$1: Internal.MobType_): number;
        getMaxCost($$0: number): number;
        isCurse(): boolean;
        isDiscoverable(): boolean;
        getMinCost($$0: number): number;
        static byId($$0: number): Internal.Enchantment;
        doPostHurt($$0: Internal.LivingEntity_, $$1: Internal.Entity_, $$2: number): void;
        getDescriptionId(): string;
        canEnchant($$0: Internal.ItemStack_): boolean;
        get rarity(): Internal.Enchantment$Rarity
        get tradeable(): boolean
        get maxLevel(): number
        get treasureOnly(): boolean
        get minLevel(): number
        get curse(): boolean
        get discoverable(): boolean
        get descriptionId(): string
        readonly category: Internal.EnchantmentCategory;
    }
    type Enchantment_ = Special.Enchantment | Enchantment;
    class GrassBlock extends Internal.SpreadingSnowyDirtBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type GrassBlock_ = GrassBlock;
    interface ReducedDestroyEffects extends Internal.CustomDestroyEffectsBlock {
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
    }
    type ReducedDestroyEffects_ = ReducedDestroyEffects;
    class BrewingStandBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly HAS_BOTTLE: Internal.BooleanProperty[];
    }
    type BrewingStandBlock_ = BrewingStandBlock;
    abstract class RuleTest {
        constructor()
        abstract test(arg0: Internal.BlockState_, arg1: Internal.RandomSource_): boolean;
        static readonly CODEC: Internal.Codec<Internal.RuleTest>;
    }
    type RuleTest_ = RuleTest | BlockStatePredicate_ | any_;
    class TinkerEffect extends Internal.MobEffect {
        constructor(typeIn: Internal.MobEffectCategory_, show: boolean)
        constructor(typeIn: Internal.MobEffectCategory_, color: number, show: boolean)
        apply(entity: Internal.LivingEntity_, duration: number, level: number): Internal.MobEffectInstance;
        apply(entity: Internal.LivingEntity_, duration: number, level: number, showIcon: boolean): Internal.MobEffectInstance;
        getLevel(entity: Internal.LivingEntity_): number;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        apply(entity: Internal.LivingEntity_, duration: number): Internal.MobEffectInstance;
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
        get curativeItems(): Internal.List<Internal.ItemStack>
    }
    type TinkerEffect_ = TinkerEffect;
    interface IForgeLikeBlock {
        hasEnchantPowerBonus(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_): boolean;
        addLandingEffects(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
    }
    type IForgeLikeBlock_ = IForgeLikeBlock;
    interface ParticleProvider$Sprite <T extends Internal.ParticleOptions> {
        abstract createParticle(arg0: T, arg1: Internal.ClientLevel_, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.TextureSheetParticle;
        (arg0: T, arg1: Internal.ClientLevel, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.TextureSheetParticle_;
    }
    type ParticleProvider$Sprite_<T extends Internal.ParticleOptions> = ParticleProvider$Sprite<T>;
    interface AccessorItem {
        abstract bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        (arg0: Internal.Item): void;
    }
    type AccessorItem_ = AccessorItem;
    interface PositionSource {
        abstract getType(): Internal.PositionSourceType<any>;
        abstract getPosition(arg0: Internal.Level_): Internal.Optional<Vec3d>;
        get type(): Internal.PositionSourceType<any>
        readonly CODEC: Internal.Codec<Internal.PositionSource>;
    }
    type PositionSource_ = PositionSource;
    class InfoBox {
        constructor()
        constructor(titleColor: number, valueColor: number)
        constructor(titleStyle: Internal.ChatFormatting_, valueStyle: Internal.ChatFormatting_)
        constructor(titleStyle: Internal.Style_, valueStyle: Internal.Style_)
        getLines(): Internal.LinkedHashMap<Internal.MutableComponent, Internal.MutableComponent>;
        setValueStyle(valueStyle: Internal.Style_): this;
        setTitleStyle(titleStyle: Internal.Style_): this;
        set(title: Internal.MutableComponent_, value: Internal.MutableComponent_): void;
        get lines(): Internal.LinkedHashMap<Internal.MutableComponent, Internal.MutableComponent>
        set valueStyle(valueStyle: Internal.Style_)
        set titleStyle(titleStyle: Internal.Style_)
        static readonly EMPTY: Internal.InfoBox;
    }
    type InfoBox_ = InfoBox;
    abstract class VarHandle implements Internal.Constable {
        getAndBitwiseAnd(...arg0: any[]): any;
        weakCompareAndSet(...arg0: any[]): boolean;
        getAndBitwiseXor(...arg0: any[]): any;
        set(...arg0: any[]): void;
        accessModeType(arg0: Internal.VarHandle$AccessMode_): Internal.MethodType;
        compareAndSet(...arg0: any[]): boolean;
        compareAndExchangeAcquire(...arg0: any[]): any;
        getAndSet(...arg0: any[]): any;
        getAndBitwiseAndRelease(...arg0: any[]): any;
        hasInvokeExactBehavior(): boolean;
        weakCompareAndSetPlain(...arg0: any[]): boolean;
        getAndBitwiseXorAcquire(...arg0: any[]): any;
        getAndBitwiseXorRelease(...arg0: any[]): any;
        setVolatile(...arg0: any[]): void;
        getAndAddAcquire(...arg0: any[]): any;
        getAndAdd(...arg0: any[]): any;
        getAndAddRelease(...arg0: any[]): any;
        getAndBitwiseOr(...arg0: any[]): any;
        getAndBitwiseOrRelease(...arg0: any[]): any;
        getAndBitwiseOrAcquire(...arg0: any[]): any;
        static releaseFence(): void;
        static fullFence(): void;
        coordinateTypes(): Internal.List<typeof any>;
        static storeStoreFence(): void;
        getAcquire(...arg0: any[]): any;
        getOpaque(...arg0: any[]): any;
        toMethodHandle(arg0: Internal.VarHandle$AccessMode_): Internal.MethodHandle;
        setOpaque(...arg0: any[]): void;
        compareAndExchange(...arg0: any[]): any;
        compareAndExchangeRelease(...arg0: any[]): any;
        getVolatile(...arg0: any[]): any;
        getAndBitwiseAndAcquire(...arg0: any[]): any;
        varType(): typeof any;
        get(...arg0: any[]): any;
        abstract withInvokeBehavior(): this;
        getAndSetAcquire(...arg0: any[]): any;
        describeConstable(): Internal.Optional<Internal.VarHandle$VarHandleDesc>;
        static acquireFence(): void;
        getAndSetRelease(...arg0: any[]): any;
        weakCompareAndSetAcquire(...arg0: any[]): boolean;
        weakCompareAndSetRelease(...arg0: any[]): boolean;
        abstract withInvokeExactBehavior(): this;
        isAccessModeSupported(arg0: Internal.VarHandle$AccessMode_): boolean;
        static loadLoadFence(): void;
        setRelease(...arg0: any[]): void;
        set "volatile"(...arg0: any[])
        set opaque(...arg0: any[])
        set release(...arg0: any[])
    }
    type VarHandle_ = VarHandle;
    interface WorldViewMixin extends Internal.RenderAttachedBlockView {
        abstract getBlockTint(arg0: BlockPos_, arg1: Internal.ColorResolver_): number;
        getMinSection(): number;
        abstract getShade(arg0: Internal.Direction_, arg1: boolean): number;
        abstract getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        abstract getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        abstract getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        abstract getHeight(): number;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        canSeeSky($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        abstract getFluidState(arg0: BlockPos_): Internal.FluidState;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getSectionsCount(): number;
        abstract getMinBuildHeight(): number;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get lightEngine(): Internal.LevelLightEngine
        get height(): number
        get sectionsCount(): number
        get minBuildHeight(): number
        get maxLightLevel(): number
    }
    type WorldViewMixin_ = WorldViewMixin;
    interface MouseDown {
        newStream(): Internal.EventStream<Internal.MouseDown>;
        abstract onMouseDown(arg0: number, arg1: number, arg2: number): boolean;
        (arg0: number, arg1: number, arg2: number): boolean;
    }
    type MouseDown_ = MouseDown;
    class EntityAnchorArgument$Anchor extends Internal.Enum<Internal.EntityAnchorArgument$Anchor> {
        static getByName($$0: string): Internal.EntityAnchorArgument$Anchor;
        static values(): Internal.EntityAnchorArgument$Anchor[];
        apply($$0: Internal.CommandSourceStack_): Vec3d;
        apply($$0: Internal.Entity_): Vec3d;
        static valueOf($$0: string): Internal.EntityAnchorArgument$Anchor;
        static readonly FEET: Internal.EntityAnchorArgument$Anchor;
        static readonly EYES: Internal.EntityAnchorArgument$Anchor;
    }
    type EntityAnchorArgument$Anchor_ = "eyes" | "feet" | EntityAnchorArgument$Anchor;
    class ItemMediaBattery extends Internal.ItemMediaHolder {
        constructor(pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getMediaFullness(stack: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly MAX_MEDIA_PREDICATE: ResourceLocation;
        static readonly MEDIA_PREDICATE: ResourceLocation;
    }
    type ItemMediaBattery_ = ItemMediaBattery;
    class FactoryPanelBlock extends Internal.FaceAttachedHorizontalDirectionalBlock implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.FactoryPanelBlockEntity>, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.PlayerDestroyBlock, Internal.SpecialBlockItemRequirement {
        constructor(p_53182_: Internal.BlockBehaviour$Properties_)
        static connectedDirection(state: Internal.BlockState_): Internal.Direction;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRequiredItems(state: Internal.BlockState_, blockEntity: Internal.BlockEntity_): Internal.ItemRequirement;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityClass(): typeof Internal.FactoryPanelBlockEntity;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static canAttachLenient(pReader: Internal.LevelReader_, pPos: BlockPos_, pDirection: Internal.Direction_): boolean;
        static getTargetedSlot(pos: BlockPos_, blockState: Internal.BlockState_, clickLocation: Vec3d_): Internal.FactoryPanelBlock$PanelSlot;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FactoryPanelBlockEntity>): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FactoryPanelBlockEntity>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static getYRot(state: Internal.BlockState_): number;
        onDestroyedByPlayer(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, player: Internal.Player_, willHarvest: boolean, fluid: Internal.FluidState_): boolean;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static getXRot(state: Internal.BlockState_): number;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FactoryPanelBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FactoryPanelBlockEntity;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FactoryPanelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        get blockEntityClass(): typeof Internal.FactoryPanelBlockEntity
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.FactoryPanelBlockEntity>
        get mod(): string
        static readonly POWERED: Internal.BooleanProperty;
    }
    type FactoryPanelBlock_ = FactoryPanelBlock;
    interface GreedyInputComponent extends io.wispforest.owo.ui.core.Component {
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        abstract horizontalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        abstract x(): number;
        abstract charTyped(): Internal.EventSource<Internal.CharTyped>;
        abstract horizontalSizing(arg0: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        abstract updateX(arg0: number): void;
        abstract mouseLeave(): Internal.EventSource<Internal.MouseLeave>;
        update(delta: number, mouseX: number, mouseY: number): void;
        abstract verticalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        remove(): void;
        hasParent(): boolean;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        abstract onFocusGained(arg0: Internal.Component$FocusSource_): void;
        abstract draw(arg0: Internal.OwoUIDrawContext_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        abstract height(): number;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        abstract positioning(arg0: Internal.Positioning_): io.wispforest.owo.ui.core.Component;
        abstract onCharTyped(arg0: string, arg1: number): boolean;
        abstract focusLost(): Internal.EventSource<Internal.FocusLost>;
        abstract focusHandler(): Internal.FocusHandler;
        abstract id(): string;
        abstract margins(): Internal.AnimatableProperty<io.wispforest.owo.ui.core.Insets>;
        abstract onMouseUp(arg0: number, arg1: number, arg2: number): boolean;
        abstract configure<C extends io.wispforest.owo.ui.core.Component>(arg0: Internal.Consumer_<C>): C;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        abstract tooltip(arg0: Internal.List_<Internal.ClientTooltipComponent>): io.wispforest.owo.ui.core.Component;
        abstract onMouseScroll(arg0: number, arg1: number, arg2: number): boolean;
        abstract inflate(arg0: Internal.Size_): void;
        abstract width(): number;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        root(): Internal.ParentComponent;
        abstract mouseUp(): Internal.EventSource<Internal.MouseUp>;
        abstract onKeyPress(arg0: number, arg1: number, arg2: number): boolean;
        abstract parent(): Internal.ParentComponent;
        abstract cursorStyle(): Internal.CursorStyle;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        shouldDrawTooltip(mouseX: number, mouseY: number): boolean;
        of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        abstract keyPress(): Internal.EventSource<Internal.KeyPress>;
        abstract y(): number;
        abstract id(arg0: string): io.wispforest.owo.ui.core.Component;
        abstract mouseEnter(): Internal.EventSource<Internal.MouseEnter>;
        abstract updateY(arg0: number): void;
        moveTo(x: number, y: number): void;
        isInBoundingBox(x: number, y: number): boolean;
        fullSize(): Internal.Size;
        abstract mouseDown(): Internal.EventSource<Internal.MouseDown>;
        abstract onMouseDrag(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
        abstract zIndex(): number;
        abstract zIndex(arg0: number): io.wispforest.owo.ui.core.Component;
        abstract onMouseDown(arg0: number, arg1: number, arg2: number): boolean;
        parseProperties(model: Internal.UIModel_, element: Internal.Element_, children: Internal.Map_<string, Internal.Element>): void;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        abstract mouseScroll(): Internal.EventSource<Internal.MouseScroll>;
        abstract focusGained(): Internal.EventSource<Internal.FocusGained>;
        abstract onFocusLost(): void;
        abstract mount(arg0: Internal.ParentComponent_, arg1: number, arg2: number): void;
        abstract mouseDrag(): Internal.EventSource<Internal.MouseDrag>;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        abstract tooltip(): Internal.List<Internal.ClientTooltipComponent>;
        abstract verticalSizing(arg0: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        abstract cursorStyle(arg0: Internal.CursorStyle_): io.wispforest.owo.ui.core.Component;
        canFocus(source: Internal.Component$FocusSource_): boolean;
        abstract positioning(): Internal.AnimatableProperty<Internal.Positioning>;
        abstract margins(arg0: io.wispforest.owo.ui.core.Insets_): io.wispforest.owo.ui.core.Component;
        abstract dismount(arg0: Internal.Component$DismountReason_): void;
    }
    type GreedyInputComponent_ = GreedyInputComponent;
    interface MenuContainer {
        abstract remove(arg0: Internal.MenuComponent_): void;
        /**
         * @deprecated
        */
        abstract postEvent(arg0: Internal.Event_): boolean;
        abstract getFont(): Internal.Font;
        get font(): Internal.Font
    }
    type MenuContainer_ = MenuContainer;
    interface GuiEventListener extends Internal.TabOrderedElement {
        charTyped($$0: string, $$1: number): boolean;
        abstract isFocused(): boolean;
        abstract setFocused(arg0: boolean): void;
        mouseReleased($$0: number, $$1: number, $$2: number): boolean;
        getTabOrderGroup(): number;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        mouseClicked($$0: number, $$1: number, $$2: number): boolean;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        getCurrentFocusPath(): Internal.ComponentPath;
        mouseDragged($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        mouseMoved($$0: number, $$1: number): void;
        getRectangle(): Internal.ScreenRectangle;
        isMouseOver($$0: number, $$1: number): boolean;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        get focused(): boolean
        set focused(arg0: boolean)
        get tabOrderGroup(): number
        get currentFocusPath(): Internal.ComponentPath
        get rectangle(): Internal.ScreenRectangle
        readonly DOUBLE_CLICK_THRESHOLD_MS: 250;
    }
    type GuiEventListener_ = GuiEventListener;
    class CaveVinesBlock extends Internal.GrowingPlantHeadBlock implements Internal.CaveVines, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static emission($$0: number): Internal.ToIntFunction<Internal.BlockState>;
        setDestroySpeed(v: number): void;
        static use($$0: Internal.Entity_, $$1: Internal.BlockState_, $$2: Internal.Level_, $$3: BlockPos_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static hasGlowBerries($$0: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CaveVinesBlock_ = CaveVinesBlock;
    class SnowyDirtBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly SNOWY: Internal.BooleanProperty;
    }
    type SnowyDirtBlock_ = SnowyDirtBlock;
    class EnderSlimeIslandStructure extends Internal.AbstractIslandStructure {
        constructor(structureSettings: Internal.Structure$StructureSettings_)
        type(): Internal.StructureType<Internal.EnderSlimeIslandStructure>;
        static readonly CODEC: Internal.Codec<Internal.EnderSlimeIslandStructure>;
    }
    type EnderSlimeIslandStructure_ = EnderSlimeIslandStructure;
    interface StationMapData {
        abstract addStationMarker(arg0: Internal.StationMarker_): void;
        abstract toggleStation(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.StationBlockEntity_): boolean;
    }
    type StationMapData_ = StationMapData;
    class Display$ItemDisplay$ItemRenderState extends Internal.Record {
        constructor($$0: Internal.ItemStack_, $$1: Internal.ItemDisplayContext_)
        itemTransform(): Internal.ItemDisplayContext;
        itemStack(): Internal.ItemStack;
    }
    type Display$ItemDisplay$ItemRenderState_ = Display$ItemDisplay$ItemRenderState;
    abstract class LoggingRecipeSerializer <T extends Internal.Recipe<any>> extends Internal.AbstractRecipeSerializer<T> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromNetwork(id: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): T;
    }
    type LoggingRecipeSerializer_<T extends Internal.Recipe<any>> = LoggingRecipeSerializer<T>;
    class ThinBambooFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type ThinBambooFeature_ = ThinBambooFeature;
    class FluidComponents$1 implements Internal.RecipeComponent<Internal.InputFluid> {
        isInput(recipe: Internal.RecipeJS_, value: Internal.InputFluid_, match: Internal.ReplacementMatch_): boolean;
        write(recipe: Internal.RecipeJS_, value: Internal.InputFluid_): Internal.JsonElement;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<Internal.InputFluid, O>;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, Internal.InputFluid>>;
        write(arg0: Internal.RecipeJS_, arg1: any): Internal.JsonElement;
        replaceInput(recipe: Internal.RecipeJS_, original: Internal.InputFluid_, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): Internal.InputFluid;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.InputFluid>, json: Internal.JsonObject_): void;
        role(): Internal.ComponentRole;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.InputFluid>;
        componentClass(): typeof any;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, Internal.InputFluid>>;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        componentType(): string;
        read(recipe: Internal.RecipeJS_, from: any): Internal.InputFluid;
        checkEmpty(arg0: Internal.RecipeKey_<any>, arg1: any): string;
        checkEmpty(key: Internal.RecipeKey_<Internal.InputFluid>, value: Internal.InputFluid_): string;
        static builder(): Internal.RecipeComponentBuilder;
        orSelf(): Internal.RecipeComponent<Internal.InputFluid>;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<Internal.InputFluid>;
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<Internal.InputFluid, O>;
        static builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        isOutput(recipe: Internal.RecipeJS_, value: Internal.InputFluid_, match: Internal.ReplacementMatch_): boolean;
        checkValueHasChanged(oldValue: Internal.InputFluid_, newValue: Internal.InputFluid_): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.InputFluid>;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<Internal.InputFluid>;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<Internal.InputFluid>;
        replaceOutput(recipe: Internal.RecipeJS_, original: Internal.InputFluid_, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): Internal.InputFluid;
        asArray(): Internal.ArrayRecipeComponent<Internal.InputFluid>;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.InputFluid>, map: Internal.Map_<any, any>): void;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.InputFluid>, json: Internal.JsonObject_): void;
        isInput(arg0: Internal.RecipeJS_, arg1: any, arg2: Internal.ReplacementMatch_): boolean;
        key(name: string): Internal.RecipeKey<Internal.InputFluid>;
    }
    type FluidComponents$1_ = FluidComponents$1;
    class LlamaSpit extends Internal.Projectile {
        constructor($$0: Internal.EntityType_<Internal.LlamaSpit>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: Internal.Llama_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type LlamaSpit_ = LlamaSpit;
    class InSquarePlacement extends Internal.PlacementModifier {
        constructor()
        static spread(): Internal.InSquarePlacement;
        static readonly CODEC: Internal.Codec<Internal.InSquarePlacement>;
    }
    type InSquarePlacement_ = InSquarePlacement;
    interface PoolSubpageMetric {
        abstract elementSize(): number;
        abstract numAvailable(): number;
        abstract pageSize(): number;
        abstract maxNumElements(): number;
    }
    type PoolSubpageMetric_ = PoolSubpageMetric;
    interface Boolean2LongFunction extends it.unimi.dsi.fastutil.Function<boolean, number> {
        getOrDefault(arg0: boolean, arg1: number): number;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2LongFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<boolean, T>;
        abstract get(arg0: boolean): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Boolean2CharFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, number>;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2LongFunction;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Boolean2ByteFunction;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2LongFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Boolean2DoubleFunction;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Boolean2ReferenceFunction<T>;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2LongFunction;
        defaultReturnValue(): number;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2LongFunction<T>;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Boolean2FloatFunction;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2LongFunction;
        remove(arg0: boolean): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2LongFunction;
        containsKey(arg0: boolean): boolean;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Boolean2IntFunction;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Boolean2ShortFunction;
        size(): number;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Boolean2ObjectFunction<T>;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2LongFunction;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        clear(): void;
        apply(arg0: boolean): number;
        put(arg0: boolean, arg1: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2LongFunction<T>;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: number): number;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: number): void;
        (arg0: boolean): number;
    }
    type Boolean2LongFunction_ = Boolean2LongFunction;
    class ScaffoldingBlockItem extends Internal.BlockItem {
        constructor($$0: Internal.Block_, $$1: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ScaffoldingBlockItem_ = ScaffoldingBlockItem;
    class MenuType <T extends Internal.AbstractContainerMenu> implements Internal.FeatureElement, Internal.MenuTypeAccessor<any> {
        constructor($$0: Internal.MenuType$MenuSupplier_<T>, $$1: Internal.FeatureFlagSet_)
        requiredFeatures(): Internal.FeatureFlagSet;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getConstructor(): Internal.MenuType$MenuSupplier<any>;
        create($$0: number, $$1: Internal.Inventory_): T;
        get "constructor"(): Internal.MenuType$MenuSupplier<any>
        static readonly MERCHANT: Internal.MenuType<Internal.MerchantMenu>;
        static readonly CARTOGRAPHY_TABLE: Internal.MenuType<Internal.CartographyTableMenu>;
        static readonly SMOKER: Internal.MenuType<Internal.SmokerMenu>;
        static readonly GENERIC_9x6: Internal.MenuType<Internal.ChestMenu>;
        static readonly ANVIL: Internal.MenuType<Internal.AnvilMenu>;
        static readonly GENERIC_9x4: Internal.MenuType<Internal.ChestMenu>;
        static readonly BEACON: Internal.MenuType<Internal.BeaconMenu>;
        static readonly LOOM: Internal.MenuType<Internal.LoomMenu>;
        static readonly STONECUTTER: Internal.MenuType<Internal.StonecutterMenu>;
        static readonly GENERIC_9x5: Internal.MenuType<Internal.ChestMenu>;
        static readonly LECTERN: Internal.MenuType<Internal.LecternMenu>;
        static readonly SHULKER_BOX: Internal.MenuType<Internal.ShulkerBoxMenu>;
        static readonly CRAFTING: Internal.MenuType<Internal.CraftingMenu>;
        static readonly SMITHING: Internal.MenuType<Internal.SmithingMenu>;
        static readonly ENCHANTMENT: Internal.MenuType<Internal.EnchantmentMenu>;
        static readonly GENERIC_9x2: Internal.MenuType<Internal.ChestMenu>;
        static readonly GENERIC_3x3: Internal.MenuType<Internal.DispenserMenu>;
        static readonly FURNACE: Internal.MenuType<Internal.FurnaceMenu>;
        static readonly GENERIC_9x3: Internal.MenuType<Internal.ChestMenu>;
        static readonly GRINDSTONE: Internal.MenuType<Internal.GrindstoneMenu>;
        static readonly GENERIC_9x1: Internal.MenuType<Internal.ChestMenu>;
        static readonly BREWING_STAND: Internal.MenuType<Internal.BrewingStandMenu>;
        static readonly HOPPER: Internal.MenuType<Internal.HopperMenu>;
        static readonly BLAST_FURNACE: Internal.MenuType<Internal.BlastFurnaceMenu>;
    }
    type MenuType_<T extends Internal.AbstractContainerMenu> = Special.Menu | MenuType<T>;
    class LivingEntity$Fallsounds extends Internal.Record {
        constructor($$0: Internal.SoundEvent_, $$1: Internal.SoundEvent_)
        small(): Internal.SoundEvent;
        big(): Internal.SoundEvent;
    }
    type LivingEntity$Fallsounds_ = LivingEntity$Fallsounds;
    interface Reference2FloatFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToDoubleFunction<K> {
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Reference2ReferenceFunction<K, T>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2FloatFunction;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Reference2DoubleFunction<K>;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Reference2CharFunction<K>;
        removeFloat(arg0: any): number;
        defaultReturnValue(arg0: number): void;
        getOrDefault(arg0: any, arg1: number): number;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2FloatFunction;
        apply(arg0: K): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2FloatFunction;
        containsKey(arg0: any): boolean;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2FloatFunction<T>;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2FloatFunction;
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Reference2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2FloatFunction;
        applyAsDouble(arg0: K): number;
        put(arg0: K, arg1: number): number;
        defaultReturnValue(): number;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        abstract getFloat(arg0: any): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Reference2IntFunction<K>;
        andThenFloat(arg0: Internal.Float2FloatFunction_): this;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Reference2LongFunction<K>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        size(): number;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2FloatFunction<T>;
        clear(): void;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Reference2ByteFunction<K>;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2FloatFunction;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Reference2ShortFunction<K>;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2FloatFunction;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        identity<T>(): Internal.Function<T, T>;
        (arg0: any): number;
    }
    type Reference2FloatFunction_<K> = Reference2FloatFunction<K>;
    class LogisticallyLinkedBlockItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static networkFromStack(pStack: Internal.ItemStack_): Internal.UUID;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static assignFrequency(stack: Internal.ItemStack_, player: Internal.Player_, frequency: Internal.UUID_): void;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static isTuned(pStack: Internal.ItemStack_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type LogisticallyLinkedBlockItem_ = LogisticallyLinkedBlockItem;
    interface ICraftingPlan {
        abstract emittedItems(): Internal.KeyCounter;
        abstract patternTimes(): Internal.Map<Internal.IPatternDetails, number>;
        abstract bytes(): number;
        abstract simulation(): boolean;
        abstract multiplePaths(): boolean;
        abstract usedItems(): Internal.KeyCounter;
        abstract finalOutput(): Internal.GenericStack;
        abstract missingItems(): Internal.KeyCounter;
    }
    type ICraftingPlan_ = ICraftingPlan;
    class VillageSectionsDebugRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        setNotVillageSection($$0: Internal.SectionPos_): void;
        setVillageSection($$0: Internal.SectionPos_): void;
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        clear(): void;
        set notVillageSection($$0: Internal.SectionPos_)
        set villageSection($$0: Internal.SectionPos_)
    }
    type VillageSectionsDebugRenderer_ = VillageSectionsDebugRenderer;
    class VillagerTypeBuilder extends Internal.BuilderBase<Internal.VillagerType> {
        constructor(i: ResourceLocation_)
        createObject(): any;
    }
    type VillagerTypeBuilder_ = VillagerTypeBuilder;
    abstract class DragGestureRecognizer implements Internal.Serializable {
        setComponent(arg0: Internal.Component_): void;
        removeDragGestureListener(arg0: Internal.DragGestureListener_): void;
        getSourceActions(): number;
        resetRecognizer(): void;
        getTriggerEvent(): Internal.InputEvent;
        addDragGestureListener(arg0: Internal.DragGestureListener_): void;
        getDragSource(): Internal.DragSource;
        getComponent(): Internal.Component;
        setSourceActions(arg0: number): void;
        set component(arg0: Internal.Component_)
        get sourceActions(): number
        get triggerEvent(): Internal.InputEvent
        get dragSource(): Internal.DragSource
        get component(): Internal.Component
        set sourceActions(arg0: number)
    }
    type DragGestureRecognizer_ = DragGestureRecognizer;
    class LazySoundType extends SoundType {
        constructor(volumeIn: number, pitchIn: number, breakSoundIn: Internal.Supplier_<Internal.SoundEvent>, stepSoundIn: Internal.Supplier_<Internal.SoundEvent>, placeSoundIn: Internal.Supplier_<Internal.SoundEvent>, hitSoundIn: Internal.Supplier_<Internal.SoundEvent>, fallSoundIn: Internal.Supplier_<Internal.SoundEvent>)
    }
    type LazySoundType_ = LazySoundType;
    class Actionable extends Internal.Enum<Internal.Actionable> {
        static values(): Internal.Actionable[];
        static valueOf(name: string): Internal.Actionable;
        static readonly MODULATE: Internal.Actionable;
        static readonly SIMULATE: Internal.Actionable;
    }
    type Actionable_ = "simulate" | Actionable | "modulate";
    class PieBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_, pieSlice: Internal.Supplier_<Internal.Item>)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getMaxBites(): number;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getPieSliceItem(): Internal.ItemStack;
        setLightEmission(v: number): void;
        getMod(): string;
        get maxBites(): number
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get pieSliceItem(): Internal.ItemStack
        set lightEmission(v: number)
        get mod(): string
        static readonly BITES: Internal.IntegerProperty;
        readonly pieSlice: Internal.Supplier<Internal.Item>;
        static readonly FACING: Internal.DirectionProperty;
    }
    type PieBlock_ = PieBlock;
}
declare namespace me.alphamode.star.mixin {
    interface EntityAccessor {
        abstract callGetSplashSound(): Internal.SoundEvent;
        abstract callGetHighSpeedSplashSound(): Internal.SoundEvent;
    }
    type EntityAccessor_ = EntityAccessor;
}
declare namespace com.electronwill.nightconfig.core.file {
    interface FileNotFoundAction {
        copyData(arg0: Internal.InputStream_): this;
        copyData(arg0: Internal.URL_): this;
        abstract run(arg0: Internal.Path_, arg1: Internal.ConfigFormat_<any>): boolean;
        copyData(arg0: Internal.File_): this;
        copyResource(arg0: string): this;
        copyData(arg0: Internal.Path_): this;
        (arg0: Internal.Path, arg1: Internal.ConfigFormat<any>): boolean;
        readonly THROW_ERROR: com.electronwill.nightconfig.core.file.FileNotFoundAction;
        readonly READ_NOTHING: com.electronwill.nightconfig.core.file.FileNotFoundAction;
        readonly CREATE_EMPTY: com.electronwill.nightconfig.core.file.FileNotFoundAction;
    }
    type FileNotFoundAction_ = FileNotFoundAction;
}
declare namespace io.github.fabricators_of_create.porting_lib.tool.extensions {
    interface ItemStackExtensions {
        canPerformAction(toolAction: Internal.ToolAction_): boolean;
    }
    type ItemStackExtensions_ = ItemStackExtensions;
}
declare namespace net.irisshaders.iris.mixin.rendertype {
    interface RenderStateShardAccessor {
        abstract getName(): string;
        getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        get name(): string
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        (): string;
    }
    type RenderStateShardAccessor_ = RenderStateShardAccessor;
}
declare namespace net.irisshaders.iris.texture {
    interface SpriteContentsExtension {
        abstract getCreatedTicker(): Internal.SpriteContents$Ticker;
        get createdTicker(): Internal.SpriteContents$Ticker
        (): Internal.SpriteContents$Ticker_;
    }
    type SpriteContentsExtension_ = SpriteContentsExtension;
}
declare namespace io.wispforest.owo.mixin.ui.layers {
    interface HandledScreenAccessor {
        abstract owo$getRootX(): number;
        abstract owo$getRootY(): number;
    }
    type HandledScreenAccessor_ = HandledScreenAccessor;
}
